# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for hardcoded defection in opponent's code
    if "return 'D'" in opponent_program_code or 'return "D"' in opponent_program_code:
        return "D"
    
    # Initial phase: Cooperate in rounds 1-3
    if current_round <= 3:
        return "C"
    
    # Middle phase: Opportunistic defections (every other round)
    if 4 <= current_round <= 7:
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    
    # Final phase: Defect if opponent is cooperative, else tit-for-tat
    if current_round >= 8:
        if len(opp_history) >= 1 and opp_history[-1] == "D":
            return "D"
        else:
            return "D"
    
    # Fallback to cooperation if no other conditions met
    return "C"